package binaron.com.handlerexample;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.widget.TextView;

public class MainActivity extends Activity {

    TextView textView;
    Handler uiHandler;
    Thread waitThread;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        uiHandler = new Handler(); // for main thread
        textView = (TextView) findViewById(R.id.text);

        waitThread = new Thread(new Runnable() {
            @Override
            public void run() {
                waitForFiveSecond();
                uiHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        textView.setText("updated");
                    }
                });
            }

            private void waitForFiveSecond() {
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        waitThread.start();
    }
}
