package binaron.com.webioexample;

import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class MainActivity extends AppCompatActivity {

    public static final String TAG = "MainActivity";

    Thread socketThread;
    Handler uiHandler;
    TextView textView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        uiHandler = new Handler();
        textView = (TextView) findViewById(R.id.text);

        socketThread = new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    // wait for 3 seconds
                    Thread.sleep(3000);

                    InetAddress ip = InetAddress.getByName("cptan.me");
                    int port = 8080;
                    Socket socket = new Socket(ip, port);

                    BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    while (socket.isConnected()) {
                        final String s = br.readLine();
                        if (s != null) {
                            uiHandler.post(new Runnable() {
                                @Override
                                public void run() {
                                    textView.setText(s);
                                }
                            });
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        socketThread.start();
    }
}
