#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>

//files counter
int f_count = 0;
int return_flag = 0;
int line_flag = 0;
int word_flag = 0;
int count_bytes_flag = 0;


int total_line = 0;
int total_word = 0;
int total_byte = 0;
char filelist[256][256];

int intlen(int in);
void interfaceHandler(int argc, char *argv[]);
void counter(int fileIndex, int **res);
int getOutputDigit();
void resultPrinter(int output_digit, int **res);

int main(int argc, char *argv[] ){
    
    //handle user interface
    interfaceHandler(argc, argv);
    
    //malloc res array
    int **res;
    res = (int **) malloc(f_count * sizeof(int *));
    int i = 0;
    for (i = 0; i < f_count; i++){
    	res[i] = (int *) malloc(3 * sizeof(int));
    }
    
    //count each file
	for(i = 0; i < f_count; i++){
		counter(i,res);
	}

	//print result
	resultPrinter(getOutputDigit(), res);

	return return_flag;
}

void counter(int fileIndex, int **res){

	int line_count = 0;
	int word_count = 0;
	int byte_count = 0;

	FILE *fp = fopen(filelist[fileIndex],"r");
	if(!fp){
		res[fileIndex][0] = -1;
		return_flag = 1;
		return;
	}

	char c;
	char pre = ' ';
	while( (c = fgetc(fp)) != EOF){
		byte_count+=1;
		if(c == '\n'){
			line_count+=1;
			if(!isspace(pre) && pre != '\n'){
				word_count+=1;
			}

		}else if(isspace(c)){
			if(!isspace(pre) && pre != '\n'){
				word_count+=1;
			}	
		}

		pre = c;
	}
	
	//store results
	res[fileIndex][0] = line_count;
	res[fileIndex][1] = word_count;
	res[fileIndex][2] = byte_count;

	total_line+=line_count;
	total_word+=word_count;
	total_byte+=byte_count;
	
	fclose(fp);

}

void interfaceHandler(int argc, char *argv[]){
    
    int i;
    int no_arg = 1;
    //user interface, you may use getopt here
    for(i = 1; i < argc; i++){
        //read args
        if( argv[i][0] == '-'){
            no_arg = 0;
            int t;
            for(t = 1; t < strlen(argv[i]);t++){
                if(argv[i][t] == 'l'){
                    line_flag = 1;
                }else if(argv[i][t] == 'w'){
                    word_flag = 1;
                }else if(argv[i][t] == 'c'){
                    count_bytes_flag = 1;
                }else {
                    return_flag = 1;
                    fprintf(stderr, "wc: invalid option -- '%c'\n",argv[i][t]);
                    fprintf(stderr, "Try 'wc --help' for more information.\n");
                    exit(1);
                }
            }
        } else {
            //files
            strcpy(filelist[f_count],argv[i]);
            f_count++;
        }
    }
    if(no_arg == 1){
        line_flag = 1;
        word_flag = 1;
        count_bytes_flag = 1;
    }

};

void resultPrinter(int digit, int **res){
	int i;
	//print each results
	for(i = 0;i < f_count;i++){
		if(res[i][0] < 0){
			fprintf(stderr, "wc: %s: No such file or directory\n",filelist[i] );
		}else{
			if(line_flag == 1){
				fprintf(stdout,"%*d ",digit,res[i][0]);
			}
			if(word_flag == 1){
				fprintf(stdout,"%*d ",digit,res[i][1]);
			}
			if(count_bytes_flag == 1){
				fprintf(stdout,"%*d ",digit,res[i][2]);
			}
			fprintf(stdout,"%s\n",filelist[i]);
		}
	}
	//multiple files, print total
	if(f_count > 1){
		if(line_flag == 1){
			fprintf(stdout,"%*d ",digit,total_line);
		}
		if(word_flag == 1){
			fprintf(stdout,"%*d ",digit,total_word);
		}
		if(count_bytes_flag == 1){
			fprintf(stdout,"%*d ",digit,total_byte);
		}
		fprintf(stdout,"total\n");
	}

}

int getOutputDigit(){
	//handle digit lenght
	int digit;
	if(f_count > 1){
		digit = intlen(total_byte);
	}else {
		if(count_bytes_flag == 0){
		    if(word_flag == 0){
		    	digit = intlen(total_line);
		    }else {
		    	digit = intlen(total_word);
		    }
		}else{
			digit = intlen(total_byte);
		}
	}
	// if we have more than one flag, the digit will be dominated by total_byte
	if( (count_bytes_flag + word_flag + line_flag) > 1)digit = intlen(total_byte);
	return digit;
}

int intlen(int in){
    int l = 1;
    while((in = (int)in/10) != 0)l++;
    return l;
}
