/****************

Unix programming demo 2

Please change <your_function_name> to your dup2 function name. 

2016.9.25 

****************/
#include <unistd.h> /*Included for dup(2) and write(2)*/
#include <stdio.h>
#include <stdlib.h> /*Included for exit()*/
#include "hw2.h"
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>


typedef int (*FunDup2)(int, int);

int getCurrentFpUsage(int max);
int isFileValid(int fd);
int same_file(int fd1, int fd2);


int main(void){

    long open_max = sysconf(_SC_OPEN_MAX);
    printf("OPEN_MAX = %ld\n",open_max);
    FunDup2 mdup2 = mydup2;

    //Open a file to write
    int file = open("results.txt", O_WRONLY | O_CREAT,0644);
    int ferr = open("failed_file.txt", O_WRONLY | O_CREAT,0644); 
    int tmp = dup2(ferr,12);
    close(ferr);
    ferr = tmp;
    
    int current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
	
    if(file < 0 || ferr < 0){
	printf("errno : %d\n",errno);	
	printf("Something wrong! %d %d\n",file,ferr);
	return 1;
    }

    //Test case 1 : redirect ferr to file, you should see the string in test1.txt
    printf("--------------------------------------------\n");
    printf("Testing testcase 1 (file1, file2)\n ");
    
    char buff[] = "Test 1: OK (2 points)\n";
    int test1 = -1;
    if( ( test1 = mdup2(file,ferr)) < 0){
	    printf("Test 1: X\n");
    }else {
    
	if( same_file(file,ferr) && test1 == ferr){
            printf("Test 1: OK (2 points)\n");
            write(ferr,buff, sizeof(buff) - 1 );
        }else {
            printf("Error: test1=%d file=%d ferr=%d\n",test1,file,ferr);
            printf("Test 1: X\n");
        }
        
    }

    current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
    
    
    //Test case 2 : invalid file as oldfd
    int invalid_file = (int)open_max + 1;
    printf("--------------------------------------------\n");
    printf("Testing testcase 2 (invalid_file,file)\n ");
    int test2;
    if( ( test2 = mdup2(invalid_file,file)) < 0){
        printf("Test 2: OK (0.5 point)\n");
    }else {
        printf("Error: %d\n",test2);
        printf("Test 2: X\n");
        
    }
    
    current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
    
    printf("--------------------------------------------\n");
    
    
    //Test case 3 : invalid file as target fd
    
    
    printf("Testing testcase 3 (file,invalid_file)\n ");
    int test3;
    if( ( test3 = mdup2(file,invalid_file)) < 0){
        printf("Test 3: OK (0.5 point)\n");
    }else {
        printf("Error: %d\n",test3);
        printf("Test 3: X\n");
    }
    
    current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
    
    printf("--------------------------------------------\n");
    
    
    //Test case 4: oldfd = newfd
    
    printf("Testing testcase 4 (oldfd = newfd)\n ");
    int test4;
    if( ( test4 = mdup2(file,file)) > 0 && test4 == file){
        printf("Test 4: OK (1 point)\n");
    }else {
        printf("Error: %d\n",test4);
        printf("Test 4: X\n");
    }
    
    current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
    
    printf("--------------------------------------------\n");
    
    
    
    
    //Test case 5: fd is reach it's limitation
    //exhaust the available fds
    while ((tmp = dup(1)) > 0);
    
    printf("Testing testcase 5\n ");
    int test5;
    if( ( test5 = mdup2(1,file)) > 0 && test5 == file){
        char buff5[] = "Test 5: OK\n";
        write(test5,buff5, sizeof(buff5) - 1 );
    }else {
        printf("Error: %d\n",test5);
        printf("Test 5: X\n");
    }
    
    current_file_usage = getCurrentFpUsage((int)open_max);
    printf("current_file_usage = %d (available: %d)\n",current_file_usage, (int)open_max - current_file_usage);
    
    printf("--------------------------------------------\n");
    
    
    close(file);
 
    return 0;
}


//check the fd1 and fd2 point to the same file
int same_file(int fd1, int fd2) {
    struct stat stat1, stat2;
    if(fstat(fd1, &stat1) < 0) return -1;
    if(fstat(fd2, &stat2) < 0) return -1;
    return (stat1.st_dev == stat2.st_dev) && (stat1.st_ino == stat2.st_ino);
}

//get the current
int getCurrentFpUsage(int max){
    int usage = 0;
    int i = 0;
    printf("used:");
    while(i < max){
        if(isFileValid(i)){
            usage++;
            printf(" %d",i);
        }
        i++;
    }
    printf("\n");
    return usage;
}

int isFileValid(int fd){
    return fcntl(fd, F_GETFD) != -1 || errno != EBADF;
}
