#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h> 
#include <limits.h>
#include <fcntl.h>
#include "hw2.h"
#include <sys/stat.h>


int mydup2(int fd, int fd2) {

	int savederr, idx;
	//fd array to store fds  
	int *tmp_fd;

	//check if fd == fd2 
	if (fd == fd2)
		return(fd2);
	
	//get the open_max from system
	long openmax = sysconf(_SC_OPEN_MAX);

	//check fd2 is valid 
	if (fd2 < 0 || fd2 >= openmax) {
		errno = EBADF;
		return(-1);
	}	
	
	//allocate the array 
	if ((tmp_fd = malloc(openmax * sizeof(int))) == NULL)
		return(-1);
	
	//check fd is valid
	/*************************
    If you are using dup to valid the oldfd, you can not dup the old fd when there is no available file descriptor.
	
	You may use "fstat(fd, %buf) != =1" or "fcntl(fd, F_GETFD) != -1" to check the fd is valid or not. 
	************************/
	//use fstat to check the fd
	struct stat buf; 
	if ( fstat(fd, &buf) == -1 ){
		//fd is not valid
		errno = EBADF;
		return(-1);
	}

	//close fd2 
	close(fd2);

	savederr = 0;
	idx = 0;

	//dup until we get desired fd2  
	while (idx < openmax) {
		if ((tmp_fd[idx] = dup(fd)) < 0) {
			savederr = errno;
			break;
		}	
		if (tmp_fd[idx] == fd2)
			break;
		idx++;
	}
    
	if (idx >= openmax)
		savederr = EMFILE;
    
	//close opened files 	
	while (--idx >= 0)
		close(tmp_fd[idx]);

	free(tmp_fd);
	errno = savederr;
	
	if (errno != 0)
		return(-1);
	else
		return(fd2);
}
